/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.logd;

import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.servlet.logd.ExpanderData;
import com.ibm.hwmca.fw.servlet.logd.GetExpanderData;
import com.ibm.hwmca.fw.servlet.logd.HexExpander;
import com.ibm.hwmca.fw.servlet.logd.LogServlet;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.cparser.ParserObj;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

public class LogInfoExpander {
    private static final String TRACE_MASKT = "XLDSCONT";
    private static final String TRACE_MASKF = "XLDSCONF";
    private static final String TRACE_MASKD = "XLDSCOND";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogdServ");
    private static final String _LogInfoTitle = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.info.title").toString();
    private static final String _infoLogBlockVersion = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.info.log.block.version").toString();
    private static final String _infoLogVersion = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.info.log.version").toString();
    private static final String _infoType = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.info.log.type").toString();
    private static final int LOG_BLOCK_VERSION_LEN = 2;
    private static final int LOG_VERSION_LEN = 4;
    private static final int LOG_TYPE_LEN = 9;
    private static final int INDEX_LOG_BLOCK_VERSION = 0;
    private static final int INDEX_LOG_VERSION = 2;
    private static final int INDEX_LOG_TYPE = 6;
    private static final int LOG_VER_1_LEN = 15;
    private Map _map;

    public LogInfoExpander(Map map) throws IOException {
        Trace.trace(TRACE_MASKT, "<> LogInfoExpander()");
        this._map = map;
        this.displayLogInfo();
    }

    private StringBuffer createLogInfoDataBuffer(byte[] hexData) {
        short blkVersion;
        StringBuffer strBuffer = new StringBuffer();
        int dataLen = hexData.length;
        Trace.trace(TRACE_MASKF, "Log info blk len=0x" + HexString.toHex(dataLen));
        if (hexData.length == 15 && (blkVersion = ParserObj.toShortSwap(hexData, 2, 0)) == 1) {
            String blkVersionStr = HexString.toHex(blkVersion);
            Trace.trace(TRACE_MASKF, "Log blk Version =0x" + blkVersionStr);
            strBuffer.append("<TR><TH align=\"left\">");
            strBuffer.append(_infoLogBlockVersion + "</TH>");
            strBuffer.append("<TD>");
            strBuffer.append(HexString.toHex(blkVersion).toUpperCase());
            strBuffer.append("</TD>");
            strBuffer.append("</TR>");
            String logVersionStr = HexString.toHex(ParserObj.toIntSwap(hexData, 4, 2)).toUpperCase();
            Trace.trace(TRACE_MASKF, "Log Version =0x" + logVersionStr);
            strBuffer.append("<TR><TH align=\"left\">");
            strBuffer.append(_infoLogVersion + "</TH>");
            strBuffer.append("<TD>");
            strBuffer.append(logVersionStr);
            strBuffer.append("</TD>");
            strBuffer.append("</TR>");
            String typeStr = new String(hexData, 6, 9).trim();
            Trace.trace(TRACE_MASKF, "Log Type= " + typeStr);
            strBuffer.append("<TR><TH align=\"left\">");
            strBuffer.append(_infoType + "</TH>");
            strBuffer.append("<TD>");
            strBuffer.append(typeStr);
            strBuffer.append("</TD>");
            strBuffer.append("</TR>");
        }
        return strBuffer;
    }

    private void displayLogInfo() throws IOException {
        Trace.trace(TRACE_MASKT, "-> LogDisplayerLogInfo()");
        ExpanderData expanderData = GetExpanderData.getData(this._map);
        if (expanderData.getDataExists()) {
            byte[] hexData = expanderData.getHexData();
            PrintWriter out = expanderData.getResponse().getWriter();
            StringBuffer strBuffer = this.createLogInfoDataBuffer(hexData);
            if (strBuffer != null && strBuffer.length() != 0) {
                out.print("<html> <script src='/js/servlettask/keys.js'></script><head><title>" + _LogInfoTitle + "</title></head>" + "<body onload='window.focus(); hideCancel();' > <pre>" + LogServlet.HTML_BACK + "<br>&nbsp;<br>" + "<TABLE cellspacing = \"2\" cellpadding = \"2\" >" + strBuffer.toString() + "</TABLE>" + "</pre> </body>" + "</html>");
            } else {
                Trace.trace(TRACE_MASKF, "Must display using default hex displayer.");
                HexExpander hex = new HexExpander(this._map);
            }
        }
        Trace.trace(TRACE_MASKT, "<- LogInfoExpander()");
    }
}

